\name{exp.farms}
          \alias{exp.farms}
          \title{Factor Analysis for Robust Microarray Summarization}
          \description{ This function converts an instance of \code{\link{AffyBatch-class}{AffyBatch.Rdash.class}}
	into an instance of \code{\link{exprSet-class}{exprSet.Rdash.class}} using
	a factor analysis model for which a Bayesian Maximum
	a Posteriori method optimizes the model parameters under the assumption
	of Gaussian measurement noise.}
\usage{
          exp.farms(object, bgcorrect.method = "none", pmcorrect.method = "pmonly", 
        normalize.method = "quantiles", weight=8, mu=0, scale=1.5, cyc=100, tol=0.00001,...)
          }
\arguments{
    \item{object}{An instance of \code{\link{AffyBatch-class}{AffyBatch.Rdash.class}}.}
	\item{weight}{Hyperparameter value  which determines the influence of the prior.} 
	\item{bgcorrect.method}{the name of the background adjustment method}
	\item{pmcorrect.method}{the name of the PM adjustement method} 
	\item{normalize.method}{the normalization method to use}
	\item{mu}{Hyperparameter value  which allows to quantify different aspects of 
	potential prior knowledge. values near zero assumes that most genes do not
	contain a signal, and introduces a bias for loading matrix elements near zero.}
	\item{scale}{Value which compensates for the reduction of variance
	during preprocessing and factor analysis (some of the data variance is
	explained by the noise).}
 	\item{cyc}{Value which determinates the maximum numbers of EM-Steps.}
	\item{tol}{Value which determinates the termination tolerance.}
	\item{...}{other arguments to be passed to \code{\link{expresso}{expresso}}.}
          }
\details{
  	This function is a wrapper for  \code{\link{expresso}}.}
\value{\code{\link[Biobase]{exprSet-class}}}
\seealso{\code{\link{expresso}}, \code{\link{q.farms}}, \code{\link{l.farms}}.}
\examples{
  data(affybatch.example)
  eset <- exp.farms(affybatch.example, weight=8, scale=1.5)
}
\keyword{manip}




