\name{generateExprVal.method.farms}
\alias{generateExprVal.method.farms}
\title{Generate an expression value from the probes informations}
\description{Generate an expression from the probe}
\usage{
          generateExprVal.method.farms(probes, weight, mu, scale, cyc, tol, ...)
          }
\arguments{
   \item{probes}{a matrix of probe intesities with rows representing
    probes and columns representing
    samples. Usually \code{pm(probeset)} where \code{probeset} is a
    of class \code{\link[affy:ProbeSet-class]{ProbeSet}}}
	\item{weight}{Hyperparameter value  which determines the influence of the prior.} 
	\item{mu}{Hyperparameter value  which allows to quantify different aspects of 
	potential prior knowledge. A value near zero assumes that most genes do not
	contain a signal, and introduces a bias for loading matrix elements near zero.}
	\item{scale}{Value which compensates for the reduction of variance
	during preprocessing and factor analysis (some of the data variance is
	explained by the noise).}
 	\item{cyc}{Value which determinates the maximum numbers of EM-Steps.}
	\item{tol}{Value which determinates the termination tolerance.}
	\item{...}{extra arguments to pass to the respective function}
    }
\value{
  A list containing entries:
  \item{exprs}{The expression values.}
  \item{se.exprs}{Estimate of the hidden variable.}
}
\seealso{
  \code{\link{generateExprSet-methods}},\code{\link{generateExprVal.method.playerout}},\code{\link{li.wong}}, \code{\link{medianpolish}}}
}
\examples{
  data(SpikeIn) ##SpikeIn is a ProbeSets
  probes <- pm(SpikeIn)
  exprs.farms <- generateExprVal.method.farms(probes)
}
\keyword{manip}