\name{l.farms}
\alias{l.farms}
\title{l.farms expression measure}
\description{
  This function converts an instance of \code{\link{AffyBatch-class}}
  into an instance of \code{\link[Biobase]{exprSet-class}} using a factor analysis model 
  for which a Bayesian Maximum a Posteriori method optimizes the model parameters under 
  the assumption of Gaussian measurement noise. This function is a wrapper for \code{\link{expresso}} 
  and uses the function \code{\link{normalize.loess}} for array normalization.
}
\usage{
          l.farms(object, weight=8, mu=0, scale=1.5, cyc=100, tol=0.00001,...)
          }
\arguments{
    	\item{object}{An instance of \code{\link{AffyBatch-class}{AffyBatch.Rdash.class}}.}
	\item{weight}{Hyperparameter value  which determines the influence of the prior.} 
	\item{mu}{Hyperparameter value  which allows to quantify different aspects of 
	potential prior knowledge. Values near zero assumes that most genes do not
	contain a signal, and introduces a bias for loading matrix elements near zero.}
	\item{scale}{Value which compensates for the reduction of variance
	during preprocessing and factor analysis (some of the data variance is
	explained by the noise).}
 	\item{cyc}{Value which determinates the maximum numbers of EM-Steps.}
	\item{tol}{Value which determinates the termination tolerance.}
	\item{...}{other arguments to be passed to \code{\link{expresso}{expresso}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\details{
  	This function is a wrapper for \code{\link{expresso}}.}	
\seealso{\code{\link{expresso}}, \code{\link{exp.farms}}, \code{\link{q.farms}}, \code{\link{normalize.loess}}}
\examples{
  data(affybatch.example)
  eset <- l.farms(affybatch.example)
}
\keyword{manip}

