\name{makeINICalls}
\alias{makeINICalls}
\title{Number of informative genes}
\description{
  This function determinates the number of informative genes of a given instance of \code{\link[Biobase]{exprSet-class}}
  which has been summarized by \code{\link{exp.farms}}, \code{\link{q.farms}} or \code{\link{l.farms}} before.}
\usage{
          makeINICalls(object)
          }
\arguments{
    	\item{object}{An instance of \code{\link[Biobase]{exprSet-class}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\seealso{\code{\link{exp.farms}}, \code{\link{q.farms}},\code{\link{l.farms}},\code{\link{showINIPlot}}}
\examples{
  data(affybatch.example)
  eset <- q.farms(affybatch.example)
  se.exprs(eset)[100:150,]<-1 # A necessary adjustment, because the affybatch.example is to small and further contains only informative genes
  IN_genes<-makeINICalls(eset)
}
\keyword{manip}

