\name{showINIPlot}
\alias{showINIPlot}
\title{Visualizes the distribution of informative / noninformatives genes}
\description{
  This function visualizes the distribution of informative and uninformative genes of a given instance of \code{\link[Biobase]{exprSet-class}} which has been summarized by \code{\link{exp.farms}}, \code{\link{q.farms}} or \code{\link{l.farms}} before.
}
\usage{
          showINIplot(object)
          }
\arguments{
    	\item{object}{An instance of \code{\link[Biobase]{exprSet-class}}.}
          }
\value{\code{\link[Biobase]{exprSet-class}}}
\seealso{\code{\link{exp.farms}}, \code{\link{q.farms}},\code{\link{l.farms}},\code{\link{showINIPlot}}}
\examples{
  data(affybatch.example)
  eset <- q.farms(affybatch.example)
  se.exprs(eset)[100:150,]<-1 # A necessary adjustment, because the affybatch.example is to small and further contains only informative genes
  showINIPlot(eset)
}
\keyword{manip}

